appModule.directive("scrollContainer",function(){
    return{
        template: '<div class="scrollable" ng-transclude ng-class="{\'hideMaxWidth\':isLink}"></div>',
        restrict: "E",
        transclude: true,
        link: function($scope,element,attrs){
            element.attr("id",$scope[attrs.id]);
            var showMoreDiv = $(".showMoreDiv",element);
            if(showMoreDiv.length > 0){
              showMoreDiv.on("click",function(){
                if($scope.onScrollUp){
                  $scope.onScrollUp(function(result){
                      if(!result || result.length == 0){
                          showMoreDiv.addClass("force-hide");
                      }
                  });
                }
              });
            }


            var upToUpdate = attrs.upToUpdate;
            $(element).on("scroll",function(){
              if(upToUpdate === "true"){
                  var that = this;
                  setTimeout(function(){
                      if($scope.onScrollUp  && that.scrollTop === 0){
                          $scope.onScrollUp();
                      }
                  },50);
                return;
              }
              if(this.scrollTop > 0 && this.clientHeight+this.scrollTop == this.scrollHeight){
                  if($scope.onScrollDown){
                      $scope.onScrollDown();
                  }
              }
            });

            var stopWatchScrollToTop = $scope.$on("scrollToTop",function(e,param){
                if(param == element.attr("id")){
                    $(element).scrollTop(0);
                }
            });

            var offNoticesInit = $scope.$on("onNoticesInit",function(e,id){
                if(upToUpdate === "true"){
                  if(element[0].scrollHeight > element[0].clientHeight){
                    var target = $("#"+id, element);
                    $(element).scrollTop(target.position().top + target.height());
                    showMoreDiv.addClass("force-hide");
                  }else{
                    showMoreDiv.removeClass("force-hide");
                  }
                }
            });

            var offScrollToBottom = $scope.$on("scrollToBottom",function(e,param,error,itemLength){
                if(param == element.attr("id")){
                    if(!error){
                        if(itemLength){
                            $(element).scrollTop(itemLength * 365);
                        }else{
                            $(element).scrollTop(element[0].scrollHeight);
                        }
                      showMoreDiv.addClass("force-hide");
                    }else{
                      showMoreDiv.removeClass("force-hide");
                    }
                }
            });

            var offWindowSizeChanged = $scope.$on("windowSizeChanged",function(e){
                //当窗体尺寸变化，滚动条不存在而且有下拉加载更多的函数时，调用这个函数。防止没有滚动条而无法下来加载更多
                if(element[0].clientHeight== element[0].scrollHeight && $scope.onScrollDown){
                    $scope.onScrollDown();
                }
            });

            var bbsCommentsBottom = $scope.$on("bbsCommentScrollChanged",function(e,param,error,itemLength){
                var scrollTop = $(element).scrollTop();
                $(element).scrollTop(scrollTop + 120);
            });

            $scope.$on("$destroy",function(){
                stopWatchScrollToTop();
                offScrollToBottom();
                offNoticesInit();
                offWindowSizeChanged();
                bbsCommentsBottom();
            });
        }
    };
});